// time limit in milliseconds, 0 disables it
const int MAX_TIME = 65000;

// maximum distances that the dummy (head) may travel before game ends
const float MAX_Z_DISTANCE = 10000;
const float MIN_Z_DISTANCE = -10000;
const float MAX_X_DISTANCE = 10000;
const float MIN_X_DISTANCE = -10000;
const float MAX_Y_DISTANCE = 100;
const float MIN_Y_DISTANCE = -100;

// text to display in the beginning
const bstr START_TEXT = "No-Name Game: Hit the Green Plate before the time runs out!";

// text to display when you win
const bstr VICTORY_TEXT = "Victory!";

// text to display when you fail
const bstr FAILURE_TEXT = "You Failed!";

// How long to display the starting text (in milliseconds)
const uint START_TEXT_TIME = 5000;

// Name of the finish block
const bstr FINISH_BLOCK_NAME = "169";

// Starting gravity
const float Z_GRAVITY = -1;
const float Y_GRAVITY = 0;
const float X_GRAVITY = 0;

// variables to hold the coordinates of the center of the screen
float SCREEN_CENTER_X;
float SCREEN_CENTER_Y;

uint mTime;
int screenWidth, screenHeight;

int timeLeft = 0;
int score = 0;
bstr ranking;

GameApp *app;
UIFont *medFont, *smallFont;
uint medFontHeight, smallFontHeight;
PhysicsWorld *pw;

PhysicsObject *objFinish;
PhysicsObject *objHead;

bool finished = false;
bool aborted = false;

// Called once on level initialization.
void onInit()
{
app = getGameApp();
screenWidth = app->getScreenWidth();
screenHeight = app->getScreenHeight();

SCREEN_CENTER_X = float(screenWidth / 2);
SCREEN_CENTER_Y = float(screenHeight / 2);

medFont = app->getFont("medium");
smallFont = app->getFont("small");
medFontHeight = medFont->getFontHeight();
smallFontHeight = smallFont->getFontHeight();

pw = app->getPhysicsWorld();
pw->setGravity(X_GRAVITY, Y_GRAVITY, Z_GRAVITY);

objHead = pw->findObject("Head");
objFinish = pw->findObject(FINISH_BLOCK_NAME);
}


// Called once for each game logic update before the physics update.
// Parameter 'time' is the simulation time in milliseconds.
void onUpdate(uint time)
{
mTime = time;
checkTime(time); // Update time and check if we've run out
checkDistance(); // check if we've fallen too far
}

// Called when the game view is rendered.
// Might happen more or less frequently than update calls.
void onRender()
{
if (mTime < START_TEXT_TIME) centerText (SCREEN_CENTER_X, SCREEN_CENTER_Y / 2, START_TEXT);
if (MAX_TIME != 0) drawTime();
if (aborted) centerText (SCREEN_CENTER_X, SCREEN_CENTER_Y, FAILURE_TEXT);
if (finished) {
centerText (SCREEN_CENTER_X, SCREEN_CENTER_Y, VICTORY_TEXT);
centerText (SCREEN_CENTER_X, SCREEN_CENTER_Y + 30, "Score: " + bstrFormat(score) + " (" + ranking + ")");
}
}

// Called when there is a collision between the two given objects.
// Returns true to create contacts or false to ignore collision.
bool onCollision(PhysicsObject *o1, PhysicsObject *o2)
{
if ((o1 == objFinish || o2 == objFinish) && !finished)
{
finished = true;
setGameState(GAMESTATE_FINISHED);
calculateScore();
getRanking();
}

// generate collision
return true;
}

void checkTime(uint time) {
if (!finished && !aborted && MAX_TIME != 0)
{
timeLeft = int(MAX_TIME) - int(time);
if (timeLeft < 0) timeLeft = 0;
if (timeLeft == 0 && !aborted)
{
aborted = true;
setGameState(GAMESTATE_ABORTED);
}
}
}


void checkDistance() {
float x, y, z = 0;
objHead->getPosition(x, y, z);
if (!aborted && (x < MIN_X_DISTANCE || x > MAX_X_DISTANCE || y < MIN_Y_DISTANCE || y > MAX_Y_DISTANCE || z < MIN_Z_DISTANCE || z > MAX_Z_DISTANCE))
{
aborted = true;
setGameState(GAMESTATE_ABORTED);
}
}

void calculateScore() {
// give score for time left
score = timeLeft;
}

void getRanking() {
// change ranking according to score
ranking = "6th";
if (score > 10000) ranking = "5th";
if (score > 20000) ranking = "4th";
if (score > 30000) ranking = "3rd";
if (score > 40000) ranking = "2nd";
if (score > 50000) ranking = "1st";
}

void drawTime()
{
const float x = 100, y = 70;
int fracs = (timeLeft / 10) % 100;
int seconds = timeLeft / 1000;
bstr fracsStr = (fracs < 10 ? "0" : "") + bstrFormat(fracs);

medFont->drawString(x, y, UIFONT_ALIGN_HORIZ_CENTER, ":");
medFont->drawString(x - 4, y, UIFONT_ALIGN_RIGHT, bstrFormat(seconds));
medFont->drawString(x + 4, y, UIFONT_ALIGN_DEFAULT, fracsStr);
smallFont->drawString(x, y + float(medFontHeight), UIFONT_ALIGN_HORIZ_CENTER, "Time Left");
}

void drawText (float x, float y, bstr text) {
medFont->drawString(x, y, UIFONT_ALIGN_DEFAULT, text);
}

void centerText (float x, float y, bstr text) {
medFont->drawString(x, y, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, text);
}