/*
 * nEckbreaker
 *
 * Based on the RagdollGeneration v0.01 by Jeroen Dessaux - Sn|p3R
 */

uint mTime;
int screenWidth, screenHeight;

int score = 0;
int somersaults = 0;
int finalsomersaults = -1;

float height = 0;
float styleScore = 0;
float finalStyleScore= 0;

GameApp *app;
UIFont *medFont, *smallFont;
uint medFontHeight, smallFontHeight;
PhysicsWorld *pw;

PhysicsObject *head, *neck, *trunk, *rthigh, *lthigh, *rcalf, *lcalf, *rfore, *lfore, *larm, *rarm, *rfoot, *lfoot;

bool finished = false;
bool aborted = false;
bool hasBeenInWater = false;

bool headAbove = true;

bool handsFirst = false, headFirst = false;
bool feetFirst = false;
bool neckFirst = false;
bool headneckFirst = false;
bool firstTouched = false;
bool kneesFirst = false;
bool elbowFirst = false;
bool trunkFirst = false;

bstr first = "";
bstr second = "";

float vedenPintaZ = -22.5;

// Called once on level initialization.
void onInit()
{
	app = getGameApp();
	screenWidth = app->getScreenWidth();
	screenHeight = app->getScreenHeight();
	medFont = app->getFont("medium");
	smallFont = app->getFont("small");
	medFontHeight = medFont->getFontHeight();
	smallFontHeight = smallFont->getFontHeight();

	app->setClearColor(0.5,0.5,0.8);

	pw = app->getPhysicsWorld();
	pw->setGravity(0, 0, -1.5);

	head = pw->findObject("Head");
	neck = pw->findObject("Neck");
	trunk = pw->findObject("Trunk");
	rthigh = pw->findObject("RightThigh");
	lthigh = pw->findObject("LeftThigh");
	rarm = pw->findObject("RightArm");
	larm = pw->findObject("LeftArm");
	rfore = pw->findObject("RightForearm");
	lfore = pw->findObject("LeftForearm");
	rcalf = pw->findObject("RightCalf");
	lcalf = pw->findObject("LeftCalf");
	rfoot = pw->findObject("RightFoot");
	lfoot = pw->findObject("LeftFoot");

	revertColors();

}

void revertColors() {
	head->setColor(1,0.7,0.5);
	neck->setColor(1,0.7,0.5);
	trunk->setColor(1,0.7,0.5);
	rthigh->setColor(1,0.7,0.5);
	lthigh->setColor(1,0.7,0.5);
	rarm->setColor(1,0.7,0.5);
	larm->setColor(1,0.7,0.5);
	rfore->setColor(1,0.7,0.5);
	lfore->setColor(1,0.7,0.5);
	rcalf->setColor(1,0.7,0.5);
	lcalf->setColor(1,0.7,0.5);
	rfoot->setColor(0.75,0.75,0.50);
	lfoot->setColor(0.75,0.75,0.50);
}


// Called once for each game logic update before the physics update.
// Parameter 'time' is the simulation time in milliseconds.
void onUpdate(uint time)
{
	mTime = time;

	float x, y, z = 0;
	head->getPosition(x, y, z);
	float headZ = z;
	
	trunk->getPosition(x,y,z);
	float trunkZ = z;
	if (z > height) height = z;

	if (!headAbove && headZ > trunkZ) {
		headAbove = true;
		somersaults++;
	} else if (headAbove && headZ < trunkZ) {
		headAbove = false;
	}

	float syvyys = vedenPintaZ - trunkZ;
	float grav = 0;
	
	// no basis in real life, just barely works, sort of ;)
	if (syvyys < 0) {
		if (!hasBeenInWater) grav = -1.5;
		
	}
	else {
		hasBeenInWater = true;
		grav = -1.5;
	}

	pw->setGravity(0, 0, grav);

	revertColors();
}


// Called when there is a collision between the two given objects.
// Returns true to create contacts or false to ignore collision.
bool onCollision(PhysicsObject *o1, PhysicsObject *o2) {
	bstr o1name = o1->getName();
	bstr o2name = o2->getName();

	if ((o1->getType() == PHYSOBJ_RAGDOLL_BODY && o2name == "lauta") || (o2->getType() == PHYSOBJ_RAGDOLL_BODY && o1name == "lauta")) {
			somersaults = 0;
			height = 0;
	}

	if (!finished && ((o2name == "laita" && o1->getType() == PHYSOBJ_RAGDOLL_BODY) || (o1name == "laita" && o2->getType() == PHYSOBJ_RAGDOLL_BODY))) {
		aborted = true;
	}

	if ((o1name == "vesi" && o2->getType() == PHYSOBJ_RAGDOLL_BODY) || (o2name == "vesi" && o1->getType() == PHYSOBJ_RAGDOLL_BODY))
	{
			if (finalsomersaults == -1) {
				finalsomersaults = somersaults;
				if (finalsomersaults > 5) finalsomersaults = 5;
			}
		
			if (!firstTouched)
			{
				if (o1->getType() == PHYSOBJ_RAGDOLL_BODY)
					first = o1name;
				else first = o2name;
				firstTouched = true;
			}
			else if (second == "" && (o1name != first && o2name != first))
			{
				if (o1->getType() == PHYSOBJ_RAGDOLL_BODY) second = o1name;
				else second = o2name;

				if ((first == "RightForearm" && second == "LeftForearm") || (second == "RightForearm" && first == "LeftForearm"))
					handsFirst = true;
				else if (first == "Head")
					headFirst = true;
				else if ((first == "RightFoot" && second == "LeftFoot") || (second == "RightFoot" && first == "LeftFoot"))
					feetFirst = true;
				else if (first == "Neck")
					neckFirst = true;
				else if (first == "Head" && second == "Neck")
					headneckFirst = true;  
				else if ((first == "RightCalf" && second == "RightThigh") || (second == "LeftCalf" && first == "LeftThigh"))
					kneesFirst = true;
				else if ((first == "RightThigh" && second == "RightCalf") || (second == "LeftThigh" && first == "LeftCalf"))
					kneesFirst = true;
				else if ((first == "RightForearm" && second == "RightArm") || (second == "LeftArm" && first == "LeftForearm"))
					elbowFirst = true;
				else if ((first == "LeftForearm" && second == "LeftArm") || (second == "RightArm" && first == "RightForearm"))
					elbowFirst = true;
				else if (first == "Trunk")
					trunkFirst = true;

				
				getStyleScore();
				if (!aborted) finished = true;
			}
		return false;
	}
	// generate collision
	return true;
}


void getStyleScore() {
	styleScore += scoreForLimb(head);
	styleScore += scoreForLimb(neck);
	styleScore += scoreForLimb(rarm);
	styleScore += scoreForLimb(larm);
	styleScore += scoreForLimb(rcalf);
	styleScore += scoreForLimb(lcalf);
	styleScore += scoreForLimb(lfoot);
	styleScore += scoreForLimb(rfoot);
	styleScore += scoreForLimb(lfore);
	styleScore += scoreForLimb(rfore);
	styleScore += scoreForLimb(rthigh);
	styleScore += scoreForLimb(lthigh);

	finalStyleScore= 12.5 + styleScore;

	if (finalStyleScore< 0) {
		styleScore = 0;
	}
	else if (finalStyleScore> 10)
	{
		finalStyleScore= 10;
	}

	finalStyleScore*= 1000;

}

float scoreForLimb(PhysicsObject *obj1) {
	float negativeX = 0, negativeY = 0;
	float x,y,z = 0;

	trunk->getPosition(x,y,z);
	float trunkX = x;
	float trunkY = y;

	obj1->getPosition(x,y,z);
	if (x>trunkX) negativeX -=  x-trunkX;
	else negativeX += x-trunkX;

	if (y>trunkY) negativeY -=  y-trunkY;
	else negativeY += y-trunkY;

	return (negativeX + negativeY) / 2;
}

// Called when the game view is rendered.
// Might happen more or less frequently than update calls.
void onRender()	{
	if (mTime < 5000) {
		medFont->drawString(float(screenWidth / 2), 70, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_BOTTOM, "nEckbreaker");
    		smallFont->drawString(float(screenWidth / 2), 90, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_BOTTOM, "\"OH MY NECK!\"");
	}
	smallFont->drawString(100,20, UIFONT_ALIGN_HORIZ_CENTER, "Turnarounds: " + bstrFormat(somersaults));
	

	if (aborted)
		drawFailure();
	if (finished)
		drawVictory();
}

void drawFailure()
{
	medFont->drawString(float(screenWidth / 2), float(screenHeight / 2), UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, "You die!", 0, 0, 0, 1);
}

void drawVictory()
{

	float r=0, g=0, b=0, a=1;

	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4), UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, "Success!");
	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4) + 60, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, "Difficulty: " + bstrFormat(int(finalsomersaults*1000)));
	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4) + 90, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, "Style: " + bstrFormat(int(finalStyleScore)));
	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4) + 180, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER,
		"Total: " + bstrFormat(int(finalStyleScore+ float(finalsomersaults * 1000) + float(handsFirst ? 1500 : 0) + float(headFirst ? 3500 : 0) + float(feetFirst ? 3000 : 0) + float(neckFirst ? 7000 : 0) + float(headneckFirst ? 5000 : 0) + float(kneesFirst ? 2500 : 0) + float(elbowFirst ? 2500 : 0) + float(trunkFirst? 1500 : 0))));

	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4) + 150, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, (handsFirst ? "Hands first +1500" : ""), 0,1,0,a);
	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4) + 150, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, (headFirst ? "Head first +3500" : ""), 0,1,0,a);	
	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4) + 150, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, (feetFirst ? "Both feet first Unique! +3000" : ""), 0,1,0,a);
	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4) + 150, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, (neckFirst ? "Neck broken! +7000" : ""), 0,1,0,a);
	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4) + 150, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, (headneckFirst ? "Head + Neck damage! +5000" : ""), 0,1,0,a);
	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4) + 150, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, (kneesFirst ? "Knee Damage +2500" : ""), 0,1,0,a);
	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4) + 150, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, (elbowFirst ? "Elbow Crusher +2500" : ""), 0,1,0,a);
	medFont->drawString(float(screenWidth / 2), float(screenHeight / 4) + 150, UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER, (trunkFirst ? "Splash Damage +1500" : ""), 0,1,0,a);
	



}
